<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['oldIp']) || empty($data['newIp'])) {
    echo json_encode(['status' => false, 'message' => 'Eski ve yeni IP adresleri gerekli']);
    exit;
}

try {
    $db = Database::getInstance();
    
    // Etkilenecek sunucuları say
    $count_result = $db->row("SELECT COUNT(*) as total FROM servers WHERE q_ip = ?", [$data['oldIp']]);
    $affected_count = $count_result['total'];
    
    if ($affected_count == 0) {
        throw new Exception('Belirtilen IP adresine sahip sunucu bulunamadı');
    }

    // Veritabanını güncelle
    $db->query(
        "UPDATE servers SET q_ip = ? WHERE q_ip = ?",
        [$data['newIp'], $data['oldIp']]
    );

    echo json_encode([
        'status' => true,
        'message' => "IP değiştirme tamamlandı. {$affected_count} sunucu etkilendi.",
        'affected' => $affected_count
    ]);

} catch (Exception $e) {
    error_log('Bulk IP Change Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'IP değiştirme hatası: ' . $e->getMessage()
    ]);
} 