<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';
require_once __DIR__ . '/../../libraries/TeamSpeak3/TeamSpeak3.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);
$server_id = $data['server_id'] ?? null;
$new_port = $data['new_port'] ?? null;

if (!$server_id || !$new_port) {
    echo json_encode(['status' => false, 'message' => 'Geçersiz parametreler']);
    exit;
}

try {
    // Veritabanı bağlantısı
    $db = Database::getInstance();
    
    // Sunucu bilgilerini al
    $server = $db->row("SELECT * FROM servers WHERE id = ?", [$server_id]);
    if (!$server) {
        throw new Exception('Sunucu bulunamadı');
    }

    // TeamSpeak bağlantısı oluştur
    $nickname = 'QueryAdmin_' . rand(1000, 9999);
    
    $uri = sprintf(
        "serverquery://%s:%s@%s:%d/?timeout=10&nickname=%s",
        $server['q_username'],
        $server['q_password'],
        $server['q_ip'],
        intval($server['q_port']),
        $nickname
    );

    $ts3 = TeamSpeak3::factory($uri);
    $ts_server = $ts3->serverGetByPort($server['port']);

    // Server Admin yetkisini ver
    $serverAdminGroup = null;
    foreach ($ts_server->serverGroupList() as $group) {
        if ($group['name'] === 'Admin Server Query') {
            $serverAdminGroup = $group;
            break;
        }
    }

    if ($serverAdminGroup) {
        $whoami = $ts_server->whoami();
        $clientDbId = $whoami['client_database_id'];
        $ts_server->serverGroupClientAdd(
            $serverAdminGroup['sgid'],
            $clientDbId
        );
    }

    // Port değiştir
    $ts_server->modify([
        'virtualserver_port' => intval($new_port)
    ]);

    // Veritabanını güncelle
    $db->query(
        "UPDATE servers SET port = ? WHERE id = ?",
        [$new_port, $server_id]
    );

    echo json_encode([
        'status' => true,
        'message' => 'Port başarıyla güncellendi'
    ]);

} catch (Exception $e) {
    error_log('Port Change Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Port değiştirme hatası: ' . $e->getMessage()
    ]);
} 