<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';
require_once __DIR__ . '/../../libraries/TeamSpeak3/TeamSpeak3.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);

// Gerekli alanları kontrol et
$required_fields = ['name', 'ip', 'port', 'q_username', 'q_password', 'q_port'];
foreach ($required_fields as $field) {
    if (empty($data[$field])) {
        echo json_encode(['status' => false, 'message' => 'Tüm alanları doldurun']);
        exit;
    }
}

try {
    // TeamSpeak bağlantısı oluştur
    $nickname = 'QueryAdmin_' . rand(1000, 9999);
    
    $uri = sprintf(
        "serverquery://%s:%s@%s:%d/?timeout=10&nickname=%s",
        $data['q_username'],
        $data['q_password'],
        $data['ip'],
        intval($data['q_port']),
        $nickname
    );

    $ts3 = TeamSpeak3::factory($uri);
    $ts_server = $ts3->serverGetByPort(intval($data['port']));

    // Server Admin yetkisini ver
    $serverAdminGroup = null;
    foreach ($ts_server->serverGroupList() as $group) {
        if ($group['name'] === 'Admin Server Query') {
            $serverAdminGroup = $group;
            break;
        }
    }

    if ($serverAdminGroup) {
        $whoami = $ts_server->whoami();
        $clientDbId = $whoami['client_database_id'];
        $ts_server->serverGroupClientAdd(
            $serverAdminGroup['sgid'],
            $clientDbId
        );
    }

    // Snapshot al
    $snapshot = $ts_server->snapshotCreate();
    $snapshot = trim($snapshot);

    // Veritabanına kaydet
    $db = Database::getInstance();
    $db->query(
        "INSERT INTO server_templates (name, json) VALUES (?, ?)",
        [
            $data['name'],
            $snapshot
        ]
    );

    echo json_encode([
        'status' => true,
        'message' => 'Template başarıyla oluşturuldu'
    ]);

} catch (Exception $e) {
    error_log('Template Creation Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Template oluşturulurken hata: ' . $e->getMessage()
    ]);
} 