<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';
require_once __DIR__ . '/../../libraries/TeamSpeak3/TeamSpeak3.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['server_id'])) {
    echo json_encode(['status' => false, 'message' => 'Sunucu ID gerekli']);
    exit;
}

try {
    $db = Database::getInstance();
    
    // Sunucu bilgilerini al
    $server = $db->row("SELECT * FROM servers WHERE id = ?", [$data['server_id']]);
    if (!$server) {
        throw new Exception('Sunucu bulunamadı');
    }

    // TeamSpeak bağlantısı oluştur
    $nickname = 'QueryAdmin_' . rand(1000, 9999);
    
    $uri = sprintf(
        "serverquery://%s:%s@%s:%d/?timeout=10&nickname=%s",
        $server['q_username'],
        $server['q_password'],
        $server['q_ip'],
        intval($server['q_port']),
        $nickname
    );

    $ts3 = TeamSpeak3::factory($uri);
    $ts_server = $ts3->serverGetByPort($server['port']);

    // Sunucuyu durdur ve sil
    $ts_server->stop();
    $ts_server->delete();

    // Veritabanından sil
    $db->query("DELETE FROM servers WHERE id = ?", [$data['server_id']]);

    echo json_encode([
        'status' => true,
        'message' => 'Sunucu başarıyla silindi'
    ]);

} catch (Exception $e) {
    error_log('Server Delete Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Sunucu silinirken hata: ' . $e->getMessage()
    ]);
} 