<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);
$template_id = $data['template_id'] ?? null;

if (!$template_id) {
    echo json_encode(['status' => false, 'message' => 'Template ID gerekli']);
    exit;
}

try {
    // Veritabanından sil
    $db = Database::getInstance();
    $db->query("DELETE FROM server_templates WHERE id = ?", [$template_id]);

    echo json_encode([
        'status' => true,
        'message' => 'Template başarıyla silindi'
    ]);

} catch (Exception $e) {
    error_log('Template Deletion Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Template silinirken hata: ' . $e->getMessage()
    ]);
} 