<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    $envFile = __DIR__ . '/../../.env';
    $env = parse_ini_file($envFile);
    
    echo json_encode([
        'status' => true,
        'settings' => [
            'admin_api_key' => $env['ADMIN_API_KEY'] ?? '',
            'api_key' => $env['API_KEY'] ?? '',
            'ts_default_server_name' => $env['TS_DEFAULT_SERVER_NAME'] ?? 'TS3.ORG.TR - Sunucu #[ID]'
        ]
    ]);
} catch (Exception $e) {
    echo json_encode([
        'status' => false,
        'message' => 'API ayarları alınamadı: ' . $e->getMessage()
    ]);
} 