<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// POST verilerini al
$data = json_decode(file_get_contents('php://input'), true);
$server_id = $data['server_id'] ?? null;

if (!$server_id) {
    echo json_encode(['status' => false, 'message' => 'Geçersiz sunucu ID']);
    exit;
}

try {
    // Veritabanı bağlantısı
    $db = Database::getInstance();
    
    // Sunucu bilgilerini al
    $server = $db->row("SELECT * FROM servers WHERE id = ?", [$server_id]);
    if (!$server) {
        throw new Exception('Sunucu bulunamadı');
    }

    // Geçici token oluştur
    $token = bin2hex(random_bytes(16));
    $expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));
    
    // Token'ı veritabanına kaydet
    $db->query(
        "INSERT INTO temporary (token, client_id, service_id, end_at) VALUES (?, ?, ?, ?)",
        [$token, $server['client_id'], $server['service_id'], $expiry]
    );
    
    // iframe URL'ini oluştur
    $url = "/?token=" . $token;
    
    echo json_encode(['status' => true, 'url' => $url]);

} catch (Exception $e) {
    echo json_encode(['status' => false, 'message' => $e->getMessage()]);
} 