<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Veritabanı bağlantısı
$db = Database::getInstance();

try {
    // Tüm sunucuları al (sayfalama olmadan)
    $servers = $db->rows(
        "SELECT id, port, q_ip, q_username, q_password, q_port, query_id as q_id, status 
         FROM servers 
         ORDER BY id DESC"
    );

    // Debug için
    error_log('Servers data: ' . print_r($servers, true));

    // JSON header'ı ekle
    header('Content-Type: application/json');

    echo json_encode([
        'status' => true,
        'servers' => $servers,
        'total' => count($servers)
    ]);

} catch (Exception $e) {
    error_log('Get Servers Error: ' . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Sunucular alınırken hata: ' . $e->getMessage()
    ]);
} 