<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Veritabanı bağlantısı
$db = Database::getInstance();

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 5;
$offset = ($page - 1) * $per_page;

// Toplam template sayısını al
$total_count = $db->row("SELECT COUNT(*) as total FROM server_templates");
$total = $total_count['total'];

// Sayfalanmış template'leri al
$templates = $db->rows("SELECT * FROM server_templates ORDER BY id DESC LIMIT ? OFFSET ?", [$per_page, $offset]);

// JSON header'ı ekle
header('Content-Type: application/json');

echo json_encode([
    'status' => true,
    'templates' => $templates,
    'total' => $total
]); 