<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

// Arama parametresini al
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$offset = ($page - 1) * $per_page;

try {
    $db = Database::getInstance();
    
    // Arama sorgusunu oluştur
    $where = '';
    $params = [];
    
    if (!empty($search)) {
        $where = "WHERE CAST(port AS CHAR) LIKE ? OR q_ip LIKE ? OR q_username LIKE ? OR id LIKE ?";
        $searchTerm = "%{$search}%";
        $params = [$searchTerm, $searchTerm, $searchTerm, $searchTerm];
    }

    // Toplam kayıt sayısını al
    $total_count = $db->row(
        "SELECT COUNT(*) as total FROM servers " . $where,
        $params
    );
    
    // Sunucuları al
    $query = "SELECT id, port, q_ip, q_username, q_password, q_port, query_id, status 
             FROM servers {$where} 
             ORDER BY id DESC 
             LIMIT ? OFFSET ?";
             
    $servers = $db->rows(
        $query,
        array_merge($params, [$per_page, $offset])
    );

    // Debug log
    error_log("Search Query: " . $query);
    error_log("Search Params: " . print_r(array_merge($params, [$per_page, $offset]), true));
    error_log("Results: " . print_r($servers, true));

    echo json_encode([
        'status' => true,
        'servers' => $servers,
        'total' => $total_count['total']
    ]);

} catch (Exception $e) {
    error_log("Search Error: " . $e->getMessage());
    echo json_encode([
        'status' => false,
        'message' => 'Sunucular alınırken hata: ' . $e->getMessage()
    ]);
} 