<?php
session_start();
require_once __DIR__ . '/../../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

try {
    $envFile = __DIR__ . '/../../.env';
    $envContent = file_get_contents($envFile);
    
    // API keylerini güncelle
    // Tırnak işaretlerini kaldırarak düzgün bir şekilde kaydet
    $adminApiKey = trim($data['admin_api_key']);
    $apiKey = trim($data['api_key']);
    $serverName = trim($data['ts_default_server_name']);
    
    // ADMIN_API_KEY güncelleme
    $envContent = preg_replace(
        '/ADMIN_API_KEY=.*/',
        'ADMIN_API_KEY="' . $adminApiKey . '"',
        $envContent
    );
    
    // API_KEY güncelleme
    $envContent = preg_replace(
        '/API_KEY=.*/',
        'API_KEY="' . $apiKey . '"',
        $envContent
    );

    // Varsayılan sunucu adını güncelle
    if (strpos($envContent, 'TS_DEFAULT_SERVER_NAME=') !== false) {
        $envContent = preg_replace(
            '/TS_DEFAULT_SERVER_NAME=.*/',
            'TS_DEFAULT_SERVER_NAME="' . $serverName . '"',
            $envContent
        );
    } else {
        $envContent .= "\nTS_DEFAULT_SERVER_NAME=\"" . $serverName . "\"";
    }
    
    // Dosyaya yaz
    file_put_contents($envFile, $envContent);
    
    echo json_encode([
        'status' => true,
        'message' => 'API ayarları başarıyla güncellendi'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'status' => false,
        'message' => 'API ayarları güncellenirken hata: ' . $e->getMessage()
    ]);
} 