<?php
session_start();
require_once __DIR__ . '/../libraries/mysql.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Veritabanı bağlantısı
$db = Database::getInstance();

// İlk 10 sunucuyu al
$servers = $db->rows("SELECT * FROM servers ORDER BY id DESC LIMIT 10");

// Toplam sunucu sayısını al
$total_count = $db->row("SELECT COUNT(*) as total FROM servers");
$total = $total_count['total'];

// Vue'ye aktarmak için verileri hazırla
$vue_data = json_encode([
    'servers' => $servers,
    'total' => $total
]);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TS3.ORG.TR - Admin Panel</title>

    <!-- Google Fonts & Material Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Vue.js -->
    <script src="../assets/js/required/vue.min.js"></script>

    <!-- Axios -->
    <script src="../assets/js/required/axios.min.js"></script>

    <!-- Tailwind CSS -->
    <script src="../assets/js/required/tailwind.min.js"></script>

    <!-- Vue Data -->
    <script>
        const vueData = <?php echo $vue_data; ?>;
    </script>
</head>
<body class="bg-[#f8fafc] font-[Poppins]">
    <div id="app" class="min-h-screen">
        <!-- Üst Bar -->
        <nav class="bg-white shadow-lg sticky top-0 z-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-col sm:flex-row justify-between h-auto sm:h-16 py-4 sm:py-0">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <h1 class="text-xl font-bold text-[#2c3e50]">TS3.ORG.TR Admin</h1>
                        </div>
                    </div>
                    <div class="flex items-center mt-4 sm:mt-0">
                        <button @click="logout" 
                                class="w-full sm:w-auto ml-0 sm:ml-3 inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-red-600 hover:bg-red-700">
                            <span class="material-icons mr-2">logout</span>
                            Çıkış Yap
                        </button>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Ana İçerik -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            <!-- Üst Butonlar -->
            <div class="mb-6 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4 px-4 sm:px-0">
                <button @click="showTemplateModal = true" 
                        class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                    <span class="material-icons mr-2">add</span>
                    Yeni Template
                </button>
                <button @click="showBulkIpModal = true"
                        class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                    <span class="material-icons mr-2">swap_horiz</span>
                    Toplu IP Değiştir
                </button>
                <button @click="openApiSettings"
                        class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                    <span class="material-icons mr-2">settings</span>
                    Sunucu Ayarları
                </button>
                <button @click="goToStats"
                        class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                    <span class="material-icons mr-2">analytics</span>
                    İstatistikler
                </button>
            </div>

            <!-- Sunucu Listesi -->
            <div class="bg-white shadow-lg rounded-lg overflow-hidden">
                <div class="px-4 py-5 border-b border-gray-200 sm:px-6 flex flex-col sm:flex-row justify-between items-start sm:items-center space-y-4 sm:space-y-0">
                    <h3 class="text-lg leading-6 font-medium text-[#2c3e50]">
                        Sunucu Listesi
                    </h3>
                    <div class="w-full sm:w-1/3">
                        <div class="relative">
                            <span class="absolute inset-y-0 left-3 flex items-center text-gray-400 material-icons text-lg">
                                search
                            </span>
                            <input type="text"
                                   v-model="search.server"
                                   class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm"
                                   placeholder="Port, IP veya kullanıcı adı ile ara...">
                        </div>
                    </div>
                </div>
                <div class="bg-white overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    ID
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    SUNUCU ADI
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    IP
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    PORT
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    DURUM
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    İŞLEMLER
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <tr v-for="server in paginatedServers" :key="server.id">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ server.id }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    TS3.ORG.TR Server #{{ server.port }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ server.q_ip }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ server.port }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span :class="[
                                        'px-2 inline-flex text-xs leading-5 font-semibold rounded-full',
                                        server.status == 1 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'
                                    ]">
                                        {{ server.status == 1 ? 'Aktif' : 'Kapalı' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <button @click="openEditModal(server)" class="text-[#2c3e50] hover:text-[#1B2630] mr-3">
                                        <span class="material-icons">settings</span>
                                    </button>
                                    <button @click="openDeleteModal(server.id)" class="text-red-600 hover:text-red-800 mr-3">
                                        <span class="material-icons">delete</span>
                                    </button>
                                    <button @click="showServerDetails(server)" class="text-[#2c3e50] hover:text-[#1B2630]">
                                        <span class="material-icons">visibility</span>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Sunucu Listesi Sayfalama -->
            <div v-if="totalServerPages > 1" class="bg-white px-4 py-3 flex items-center justify-between border-t border-gray-200 sm:px-6">
                <div class="flex-1 flex justify-between sm:hidden">
                    <button @click="serverPage > 1 && (serverPage--)"
                            :disabled="serverPage === 1"
                            class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Önceki
                    </button>
                    <button @click="serverPage < totalServerPages && (serverPage++)"
                            :disabled="serverPage === totalServerPages"
                            class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Sonraki
                    </button>
                </div>
                <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                    <div>
                        <p class="text-sm text-gray-700">
                            Toplam <span class="font-medium">{{ totalServers }}</span> sunucudan
                            <span class="font-medium">{{ (serverPage - 1) * perPage + 1 }}</span>
                            -
                            <span class="font-medium">{{ Math.min(serverPage * perPage, totalServers) }}</span>
                            arası gösteriliyor
                        </p>
                    </div>
                    <div>
                        <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px">
                            <button v-for="page in totalServerPages"
                                    :key="page"
                                    @click="serverPage = page"
                                    :class="[
                                        'relative inline-flex items-center px-4 py-2 border text-sm font-medium',
                                        page === serverPage 
                                            ? 'z-10 bg-[#2c3e50] border-[#2c3e50] text-white'
                                            : 'bg-white border-gray-300 text-gray-500 hover:bg-gray-50'
                                    ]">
                                {{ page }}
                            </button>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Template Listesi -->
            <div class="mt-8 bg-white shadow-lg rounded-lg overflow-hidden">
                <div class="px-4 py-5 border-b border-gray-200 sm:px-6 flex justify-between items-center">
                    <h3 class="text-lg leading-6 font-medium text-[#2c3e50]">
                        Template Listesi
                    </h3>
                    <div class="w-1/3">
                        <div class="relative">
                            <span class="absolute inset-y-0 left-3 flex items-center text-gray-400 material-icons text-lg">
                                search
                            </span>
                            <input type="text"
                                   v-model="search.template"
                                   class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm"
                                   placeholder="Template adı veya açıklama ile ara...">
                        </div>
                    </div>
                </div>
                <div class="bg-white">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">İsim</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Açıklama</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <tr v-for="template in paginatedTemplates" :key="template.id">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ template.id }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ template.name }}</td>
                                    <td class="px-6 py-4 text-sm text-gray-900">{{ template.description }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <button @click="deleteTemplate(template.id)" 
                                                :disabled="loading.delete"
                                                class="text-red-600 hover:text-red-800">
                                            <span v-if="loading.delete" class="material-icons animate-spin">refresh</span>
                                            <span v-else class="material-icons">delete</span>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Template Listesi Sayfalama -->
            <div v-if="totalTemplatePages > 1" class="bg-white px-4 py-3 flex items-center justify-between border-t border-gray-200 sm:px-6">
                <!-- Benzer sayfalama yapısı template'ler için -->
            </div>
        </div>

        <!-- Port Değiştirme Modal -->
        <div v-if="showPortModalFlag" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Port Değiştir</h3>
                        <div class="mt-2">
                            <input type="number" 
                                   v-model="newPort" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-[#2c3e50] focus:border-[#2c3e50] sm:text-sm"
                                   placeholder="Yeni port">
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="changePort" 
                                :disabled="loading.port"
                                class="w-full inline-flex justify-center items-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-[#2c3e50] text-base font-medium text-white hover:bg-[#1B2630] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2c3e50] sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.port" class="material-icons animate-spin mr-2">refresh</span>
                            Kaydet
                        </button>
                        <button @click="showPortModalFlag = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Template Oluşturma Modal -->
        <div v-if="showTemplateModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Yeni Template</h3>
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Template Adı</label>
                                <input type="text" v-model="newTemplate.name" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">IP Adresi</label>
                                    <input type="text" v-model="newTemplate.ip" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Port</label>
                                    <input type="number" v-model="newTemplate.port" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query Kullanıcı Adı</label>
                                    <input type="text" v-model="newTemplate.username" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query Şifresi</label>
                                    <input type="password" v-model="newTemplate.password" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Query Port</label>
                                <input type="number" v-model="newTemplate.q_port" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="createTemplate" 
                                :disabled="loading.template"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-[#2c3e50] text-base font-medium text-white hover:bg-[#1B2630] sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.template" class="material-icons animate-spin mr-2">refresh</span>
                            Oluştur
                        </button>
                        <button @click="showTemplateModal = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Toplu IP Değiştirme Modal -->
        <div v-if="showBulkIpModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Toplu IP Değiştir</h3>
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Eski IP</label>
                                <input type="text" v-model="bulkIpChange.oldIp" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm"
                                       placeholder="Değiştirilecek IP">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Yeni IP</label>
                                <input type="text" v-model="bulkIpChange.newIp" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm"
                                       placeholder="Yeni IP">
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="changeBulkIp" 
                                :disabled="loading.bulkIp"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-[#2c3e50] text-base font-medium text-white hover:bg-[#1B2630] sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.bulkIp" class="material-icons animate-spin mr-2">refresh</span>
                            Değiştir
                        </button>
                        <button @click="showBulkIpModal = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sunucu Detay Modal -->
        <div v-if="showDetailsModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:w-[1366px]">
                    <div class="bg-white">
                        <iframe v-if="selectedServer" 
                                :src="iframeUrl" 
                                class="w-full h-[768px]" 
                                frameborder="0"></iframe>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="showDetailsModal = false" 
                                class="w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:w-auto sm:text-sm">
                            Kapat
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alert Component -->
        <div v-if="alert.show" 
             :class="[
                 'fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg',
                 alert.type === 'success' ? 'bg-green-500' : 
                 alert.type === 'error' ? 'bg-red-500' : 
                 'bg-yellow-500'
             ]">
            <div class="flex items-center text-white">
                <span class="material-icons mr-2">
                    {{ alert.type === 'success' ? 'check_circle' : 
                       alert.type === 'error' ? 'error' : 
                       'warning' }}
                </span>
                {{ alert.message }}
            </div>
        </div>

        <!-- Düzenleme Modalı -->
        <div v-if="showEditModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Sunucu Düzenle</h3>
                        <div class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Port</label>
                                    <input type="number" v-model="editServer.port" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                    <div class="mt-2">
                                        <label class="inline-flex items-center">
                                            <input type="checkbox" 
                                                   v-model="editServer.updatePortOnTs3"
                                                   class="rounded border-gray-300 text-[#2c3e50] focus:ring-[#2c3e50]">
                                            <span class="ml-2 text-sm text-gray-600">Port'u sunucuda güncelle</span>
                                        </label>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">IP Adresi</label>
                                    <input type="text" v-model="editServer.ip" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query Kullanıcı Adı</label>
                                    <input type="text" v-model="editServer.q_username" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query Şifresi</label>
                                    <input type="password" v-model="editServer.q_password" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query Port</label>
                                    <input type="number" v-model="editServer.q_port" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Query ID</label>
                                    <input type="text" v-model="editServer.q_id" 
                                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="updateServer" 
                                :disabled="loading.edit"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-[#2c3e50] text-base font-medium text-white hover:bg-[#1B2630] sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.edit" class="material-icons animate-spin mr-2">refresh</span>
                            Kaydet
                        </button>
                        <button @click="showEditModal = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Silme Onay Modalı -->
        <div v-if="showDeleteModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                                <span class="material-icons text-red-600">warning</span>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Sunucuyu Sil
                                </h3>
                                <div class="mt-2">
                                    <p class="text-sm text-gray-500">
                                        Bu sunucuyu silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="deleteServer" 
                                :disabled="loading.delete"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.delete" class="material-icons animate-spin mr-2">refresh</span>
                            Sil
                        </button>
                        <button @click="showDeleteModal = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- API Ayarları Modal -->
        <div v-if="showApiSettingsModal" class="fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-center justify-center min-h-screen px-4 text-center">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-middle bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Sunucu Ayarları</h3>
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Admin API Key</label>
                                <input type="text" v-model="apiSettings.admin_api_key" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">API Key</label>
                                <input type="text" v-model="apiSettings.api_key" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Varsayılan Sunucu Adı</label>
                                <input type="text" v-model="apiSettings.ts_default_server_name" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-[#2c3e50] focus:border-[#2c3e50] text-sm"
                                       placeholder="TS3.ORG.TR - Sunucu #[ID]">
                                <p class="mt-1 text-sm text-gray-500">
                                    Not: [ID] etiketi sunucu ID'si ile değiştirilecektir
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button @click="updateApiSettings" 
                                :disabled="loading.apiSettings"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-[#2c3e50] text-base font-medium text-white hover:bg-[#1B2630] sm:ml-3 sm:w-auto sm:text-sm">
                            <span v-if="loading.apiSettings" class="material-icons animate-spin mr-2">refresh</span>
                            Kaydet
                        </button>
                        <button @click="showApiSettingsModal = false" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            İptal
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/admin.js"></script>

    <!-- Mobil görünüm için tablo düzenlemesi -->
    <style>
    @media (max-width: 640px) {
        table {
            display: block;
        }
        
        thead {
            display: none;
        }
        
        tr {
            display: block;
            margin-bottom: 1rem;
            border-bottom: 2px solid #edf2f7;
            padding: 1rem;
        }
        
        td {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            text-align: right;
        }
        
        td::before {
            content: attr(data-label);
            font-weight: 500;
            margin-right: 1rem;
            text-align: left;
        }
    }
    </style>
</body>
</html>    