<?php
session_start();
require_once __DIR__ . '/../libraries/mysql.php';

// Zaten giriş yapmışsa panele yönlendir
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.php');
    exit;
}

// API Key kontrolü
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $api_key = trim($_POST['api_key'] ?? '');
    
    $envFile = __DIR__ . '/../.env';
    if (!file_exists($envFile)) {
        $error = '.env dosyası bulunamadı';
    } else {
        $env = parse_ini_file($envFile, false, INI_SCANNER_RAW);
        if (!$env || !isset($env['ADMIN_API_KEY'])) {
            $error = 'API key yapılandırması bulunamadı';
        } else {
            $admin_api_key = trim($env['ADMIN_API_KEY'], '"\'');

            if ($api_key === $admin_api_key) {
                $_SESSION['admin_logged_in'] = true;
                header('Location: index.php');
                exit;
            } else {
                $error = 'Geçersiz API Key';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TS3.ORG.TR - Admin Girişi</title>

    <!-- Google Fonts & Material Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="../assets/js/required/tailwind.min.js"></script>
</head>
<body class="bg-[#f8fafc] font-[Poppins]">
    <div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full">
            <!-- Logo ve Başlık -->
            <div class="text-center mb-8">
                <h2 class="text-3xl font-bold text-[#2c3e50]">
                    TS3.ORG.TR
                </h2>
                <p class="mt-2 text-gray-600">Admin Panel Girişi</p>
            </div>

            <!-- Giriş Formu -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <?php if (isset($error)): ?>
                    <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative">
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>

                <form method="POST" class="space-y-6">
                    <div>
                        <label for="api_key" class="block text-sm font-medium text-[#2c3e50]">
                            API Key
                        </label>
                        <div class="mt-1 relative">
                            <input id="api_key" 
                                   name="api_key" 
                                   type="password" 
                                   required 
                                   class="appearance-none block w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#2c3e50] focus:border-transparent">
                            <span class="absolute right-3 top-2 text-gray-400 cursor-pointer material-icons"
                                  onclick="togglePassword()">
                                visibility_off
                            </span>
                        </div>
                    </div>

                    <div>
                        <button type="submit" 
                                class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-[#2c3e50] hover:bg-[#1B2630] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2c3e50]">
                            <span class="material-icons mr-2">login</span>
                            Giriş Yap
                        </button>
                    </div>
                </form>
            </div>

            <!-- Alt Bilgi -->
            <p class="mt-4 text-center text-sm text-gray-600">
                TS3.ORG.TR &copy; <?php echo date('Y'); ?> Tüm hakları saklıdır.
            </p>
        </div>
    </div>

    <script>
        function togglePassword() {
            const input = document.getElementById('api_key');
            const icon = document.querySelector('.material-icons');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.textContent = 'visibility';
            } else {
                input.type = 'password';
                icon.textContent = 'visibility_off';
            }
        }
    </script>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .material-icons {
            font-size: 20px;
        }
    </style>
</body>
</html> 