<?php
session_start();
require_once __DIR__ . '/../libraries/mysql.php';
require_once __DIR__ . '/../libraries/TeamSpeak3/TeamSpeak3.php';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Veritabanı bağlantısı
$db = Database::getInstance();

// Benzersiz IP'leri al
$unique_ips = $db->rows("SELECT DISTINCT q_ip, q_username, q_password, q_port FROM servers");

$stats = [];
$total_users = 0;
$total_active_servers = 0;
$total_servers = 0;
$chart_data = [
    'labels' => [],
    'users' => [],
    'servers' => [],
    'ports' => []
];

foreach ($unique_ips as $server_info) {
    try {
        $nickname = 'QueryAdmin_' . rand(1000, 9999);
        
        $uri = sprintf(
            "serverquery://%s:%s@%s:%d/?timeout=10&nickname=%s",
            $server_info['q_username'],
            $server_info['q_password'],
            $server_info['q_ip'],
            intval($server_info['q_port']),
            $nickname
        );

        $ts3 = TeamSpeak3::factory($uri);
        $virtual_servers = $ts3->serverList();
        
        $ip_stats = [
            'ip' => $server_info['q_ip'],
            'total_servers' => count($virtual_servers),
            'total_users' => 0,
            'active_servers' => 0,
            'ports' => [],
            'peak_users' => 0,
            'uptime' => 0
        ];

        foreach ($virtual_servers as $virtual_server) {
            try {
                $clients = intval($virtual_server['virtualserver_clientsonline']) - intval($virtual_server['virtualserver_queryclientsonline']);
                $status = strtolower($virtual_server['virtualserver_status']);
                $port = intval($virtual_server['virtualserver_port']);
                
                $ip_stats['ports'][] = $port;
                
                if ($status === 'online' || $status === 'running' || $status === '1') {
                    $ip_stats['active_servers']++;
                    $ip_stats['total_users'] += $clients;
                    $ip_stats['peak_users'] = max($ip_stats['peak_users'], intval($virtual_server['virtualserver_maxclients']));
                    $ip_stats['uptime'] += intval($virtual_server['virtualserver_uptime']);
                }
            } catch (Exception $e) {
                continue;
            }
        }

        $total_users += $ip_stats['total_users'];
        $total_active_servers += $ip_stats['active_servers'];
        $total_servers += $ip_stats['total_servers'];
        
        // Chart verilerini hazırla
        $chart_data['labels'][] = $server_info['q_ip'];
        $chart_data['users'][] = $ip_stats['total_users'];
        $chart_data['servers'][] = $ip_stats['active_servers'];
        $chart_data['ports'][] = count($ip_stats['ports']);
        
        $stats[] = $ip_stats;
    } catch (Exception $e) {
        continue;
    }
}

// JSON verilerini hazırla
$chart_json = json_encode($chart_data);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TS3.ORG.TR - İstatistikler</title>

    <!-- Google Fonts & Material Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="../assets/js/required/tailwind.min.js"></script>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-[#f8fafc] font-[Poppins]">
    <!-- Üst Bar -->
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center">
                        <h1 class="text-xl font-bold text-[#2c3e50]">TS3.ORG.TR İstatistikler</h1>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="index.php" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                        <span class="material-icons mr-2">dashboard</span>
                        Panel
                    </a>
                    <button onclick="window.location.reload()" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-[#2c3e50] hover:bg-[#1B2630]">
                        <span class="material-icons mr-2">refresh</span>
                        Yenile
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Ana İçerik -->
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <!-- Genel İstatistikler -->
        <div class="mb-8 grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="bg-white rounded-lg shadow-lg p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500">
                        <span class="material-icons">people</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-500">Toplam Kullanıcı</p>
                        <p class="text-2xl font-semibold text-[#2c3e50]"><?php echo $total_users; ?></p>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-500">
                        <span class="material-icons">dns</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-500">Aktif Sunucu</p>
                        <p class="text-2xl font-semibold text-[#2c3e50]"><?php echo $total_active_servers; ?></p>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-purple-100 text-purple-500">
                        <span class="material-icons">storage</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-500">Toplam Sunucu</p>
                        <p class="text-2xl font-semibold text-[#2c3e50]"><?php echo $total_servers; ?></p>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-yellow-100 text-yellow-500">
                        <span class="material-icons">router</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-500">Toplam IP</p>
                        <p class="text-2xl font-semibold text-[#2c3e50]"><?php echo count($unique_ips); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Grafikler -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
            <!-- Kullanıcı Dağılımı -->
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h3 class="text-lg font-medium text-[#2c3e50] mb-4">Kullanıcı Dağılımı</h3>
                <canvas id="userChart"></canvas>
            </div>
            <!-- Sunucu Dağılımı -->
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h3 class="text-lg font-medium text-[#2c3e50] mb-4">Sunucu Dağılımı</h3>
                <canvas id="serverChart"></canvas>
            </div>
        </div>

        <!-- IP Bazlı İstatistikler -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($stats as $ip_stat): ?>
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h3 class="text-lg font-medium text-[#2c3e50] mb-4">
                    IP: <?php echo htmlspecialchars($ip_stat['ip']); ?>
                </h3>
                <div class="space-y-3">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Toplam Sunucu:</span>
                        <span class="font-semibold text-[#2c3e50]"><?php echo $ip_stat['total_servers']; ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Aktif Sunucu:</span>
                        <span class="font-semibold text-[#2c3e50]"><?php echo $ip_stat['active_servers']; ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Toplam Kullanıcı:</span>
                        <span class="font-semibold text-[#2c3e50]"><?php echo $ip_stat['total_users']; ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Maksimum Kapasite:</span>
                        <span class="font-semibold text-[#2c3e50]"><?php echo $ip_stat['peak_users']; ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Port Sayısı:</span>
                        <span class="font-semibold text-[#2c3e50]"><?php echo count($ip_stat['ports']); ?></span>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <script>
        // Chart verilerini al
        const chartData = <?php echo $chart_json; ?>;

        // Kullanıcı grafiği
        new Chart(document.getElementById('userChart'), {
            type: 'bar',
            data: {
                labels: chartData.labels,
                datasets: [{
                    label: 'Kullanıcı Sayısı',
                    data: chartData.users,
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Sunucu grafiği
        new Chart(document.getElementById('serverChart'), {
            type: 'bar',
            data: {
                labels: chartData.labels,
                datasets: [{
                    label: 'Aktif Sunucular',
                    data: chartData.servers,
                    backgroundColor: 'rgba(75, 192, 192, 0.5)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }, {
                    label: 'Port Sayısı',
                    data: chartData.ports,
                    backgroundColor: 'rgba(255, 159, 64, 0.5)',
                    borderColor: 'rgba(255, 159, 64, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Otomatik yenileme - her 30 saniyede bir
        setInterval(() => {
            window.location.reload();
        }, 30000);
    </script>
</body>
</html>